//Masquerade code in C for HTTP testing 
//by Andrew Citron, with help from Ivan Heninger, both of IBM
//
//Can be adapted for use in Java code
//
//
//
// Data Declarations, this information could also be read from disk

// Set of header fields to add to a request for an image.  To add
// an additional header, simply add to the array.  No other code
// change is required.

char *imageHdrs[] = {
//  make requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono8\r\nUA-pixels: 640x480",
//  headers to make requests look like IE401 running on NT
//  the http protocol version field will not match browser if the test tool runs
//  on 1.0 because IE401 sends 1.1.  You could use a different ACCEPT_COMMAND for this element
     "Accept-Language: en-us\r\nAccept-Encoding: gzip, deflate\r\nConnection: Keep-Alive\r\nUser-Agent: Mozilla/4.0 (compatible; MSIE 4.01; Windows NT)\r\nAccept: image/gif, image/x-bitmap, image/jpeg, image/pjpeg, */*",
//  headers to make requests look like HandWeb running on PalmOS
     "User-Agent: Mozilla/3.0 (compatible; HandHTTP 1.0)\r\nAccept: */*",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono8\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono4\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono2\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono16\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color8\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color4\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color2\r\n:UA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color16\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color8\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color4\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color2\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color16\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
    "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color2\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color16\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono8\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono4\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono2\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono16\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono8\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono4\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono2\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono16\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color8\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color4\r\nUA-pixels: 240x640",
//  headers to make requests look like Netscape 4.5 running on 95
     "Accept-Language:en\r\nAccept-Encoding: gzip\r\nConnection: Keep-Alive\r\nAccept-Charset: iso-8859-1,*,utf-8\r\nUser-Agent: Mozilla/4.5 [en] (Win95; U)\r\nAccept: image/gif, image/x-bitmap, image/jpeg, image/pjpeg, image/prg, */*",
//  headers to make requests look like Nokia 7110 Wap phone
     "User-Agent: Nokia-WAP-Toolkit/1.2\r\nAccept: */*" 
 
      };

// set of headers to be used when fetching html
char *htmlHdrs[] = {
//  make requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono8\r\nUA-pixels: 640x480",
//  headers to make requests look like HandWeb running on PalmOS
     "User-Agent: Mozilla/3.0 (compatible; HandHTTP 1.0)\r\nAccept: */*",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono8\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono4\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono2\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono16\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color8\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color4\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color2\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color16\r\nUA-pixels: 640x480",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color8\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
    "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color4\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color2\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color16\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color2\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color16\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono8\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono4\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono2\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono16\r\nUA-pixels: 160x120",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono8\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono4\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono2\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: mono16\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color8\r\nUA-pixels: 240x640",
//  headers for making requests look like Explorer on a CE hand-held
     "User-Agent: Mozilla/2.0 (compatible; MSIE 3.02; Windows CE)\r\nAccept: */*\r\nUA-color: color4\r\nUA-pixels: 240x640",
//  headers to make requests look like Nokia 7110 Wap phone 
     "User-Agent: Nokia-WAP-Toolkit/1.2\r\nAccept: text/vnd.wap.wml, */*" 
     };

// the following routine uses the above array to generate different request headers
// This is needed because different transforms occur based on the different
// request headers.
// Input:  url: is the url being fetched.  It is used to determine if an
//              image or html file is being fetched
// Output: pointer to a string that includes the http headers that
//              are included with the http GET request
// Limitation: if url is not *.jpg, *.jpeg, or *.gif is is assumed to be html
char * GenerateHTTPHeaders(char * url) 
{

  char * headerPtr = NULL;
  static int httpIndex = 0;
  static int imageIndex = 0;

  static int httpHdrArraySize = sizeof(htmlHdrs)/sizeof(char*);
  static int imageHdrArraySize = sizeof(imageHdrs)/sizeof(char*);

  char *  pFn=strrchr(url,'/');                //look for / in url
  if ((pFn == NULL) || (2 == strlen(pFn)) )    // there is no / in url, or it ends in /
  {
     pFn=strrchr(url,'.');                     //look for . in url

  }
  else
  {                                            // there was a /, now look for .
     pFn=strrchr(pFn,'.');    
  }

  if (pFn && ( (strcmp(pFn, ".jpg") == 0) ||   // is it an image file?
               (strcmp(pFn, ".jpeg") == 0) ||
               (strcmp(pFn, ".gif") == 0)) )
  {
     headerPtr = imageHdrs[imageIndex++];
     imageIndex %= imageHdrArraySize;        

  }
  else
  {   
     headerPtr = htmlHdrs[httpIndex++];
     httpIndex %= httpHdrArraySize;

  }              

  return headerPtr;
}

// Here's a code snippet to call the above routine
void get(char *url){      // url has a string such as "www.ibm.com/index.htm"
 
   // data declarations  
   #define MAXCOMMANDLEN	256
   #define HEADERBUFSIZ	(8*1024)                  // plenty of extra space
 
   char getcommand[MAXCOMMANDLEN + HEADERBUFSIZ+1]; // build header here
   
   sprintf(getcommand, "GET %s HTTP/1.0\r\n%s%s", url,           
                                               GenerateHTTPHeaders(url),
                                               "\r\n\r\n" );   
   // put code that sends 'getcommand' to the web here...
   
}

